<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddDishesOrdersStatusNotifications extends Migration
{
    public function up(): void
    {
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => false,
                'event' => 'Inside\Notify\Events\CustomNotificationEvent',
                'model' => 'Inside\Content\Models\Contents\DishesOrders',
                'action' => 'isAvailable',
                'type' => 'system',
                'condition' => '',
                'multiple' => true,
                'language' => false,
                'profile' => false
            ],
            [
                'data' => [
                    'title' => 'notifications.dishes.status.available.title',
                    'text' => 'notifications.dishes.status.available.text',
                    'fields' => [
                        'title',
                    ],
                ]
            ]
        );
        $notificationTypes[] = NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Notify\Events\CustomNotificationEvent',
                'model' => 'Inside\Content\Models\Contents\DishesOrders',
                'action' => 'isAvailable',
                'type' => 'system',
                'condition' => '',
                'multiple' => true,
                'language' => false,
                'profile' => false
            ],
            [
                'data' => [
                    'title' => "notifications.dishes.status.available.title",
                    'description' => 'notifications.dishes.status.available.text',
                    'mail' => [
                        'subject' => 'notifications.dishes.status.available.subject',
                        'text' => 'notifications.dishes.status.available.content',
                        'buttonText' => 'notifications.dishes.status.available.buttonText'
                    ],
                    'fields' => [
                        'title'
                    ],
                ]
            ]
        );
    }

    public function down(): void
    {
    }
}
