<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddGroupsEventsColorField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'groups_events',
            'color',
            [
                'name' => 'color',
                'searchable' => false,
                'translatable' => false,
                'default' => null,
                'search_result_field' => false,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'en' => 'Color',
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 6,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
            6
        );
    }

    public function down(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'groups_events', 'color');
    }
}
