<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRoomReservationStatusTable extends Migration
{
    public function up(): void
    {
        Schema::create(
            'inside_room_reservation_status',
            function (Blueprint $table) {
                $table->increments('id');
                $table->uuid('room_reservation_id');
                $table->longText('comment')->nullable();
                $table->boolean('ready')->default(false);
                $table->date('date')->nullable();
                $table->timestamps();
                $table->unique(['room_reservation_id', 'date']);
            }
        );
        Schema::table(
            'inside_room_reservation_status',
            function (Blueprint $table) {
                $table->foreign('room_reservation_id')->references('uuid')->on('inside_content_rooms_reservations')
                      ->onDelete('cascade');
            }
        );
    }

    public function down(): void
    {
        Schema::table(
            'inside_room_reservation_status',
            function (Blueprint $table) {
                $table->dropForeign('inside_room_reservation_status_room_reservation_id_foreign');
            }
        );
        Schema::drop('inside_room_reservation_status');
    }
}
