<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Library;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class AddSeatsOnReservationContents extends Migration
{
    use CreateContentTypes;

    /**
     * @var array
     */
    protected $columnsToAdd = [
        'rooms_reservations' => [
            'seats' => [
                'name' => 'seats',
                'searchable' => false,
                'searchable_filter' => false,
                'translatable' => false,
                'default' => 0,
                'search_result_field' => false,
                'required' => true,
                'weight' => 2,
                'title' => [
                    'en' => 'Seats',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [],
                    'weight' => 2,
                    'group' => null,
                ],
                'type' => BridgeContentType::INTEGER_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
        ],
    ];

    public function up(): void
    {
        $this->bootUp(__FILE__, 'lied reservations');

        $this->getConsole()->writeln("<info>Modification pour Liedekerke</info>");

        $this->addColumns();
    }

    protected function addColumns(): void
    {
        $typeBridge = new BridgeContentType();
        foreach ($this->columnsToAdd as $type => $columns) {
            foreach ($columns as $name => $column) {
                $this->getConsole()->write(
                    '<info>Ajout du champ <fg=blue>'.$name.'</fg=blue> au type <fg=yellow>'.$type
                    .'</fg=yellow></info>'
                );
                try {
                    $typeBridge->contentTypeCreateOrUpdateField(
                        $type,
                        $name,
                        $column
                    );
                } catch (Exception $e) {
                    $this->getConsole()->writeln(' <fg=red>✘</fg=red>');
                    $this->getConsole()->writeln('<fg=red>'.$e->getMessage().'</fg=red>');
                    continue;
                }
                $this->getConsole()->writeln(' <fg=green>✔</fg=green>');
            }
        }
    }
}
