<?php


use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Weekdays;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class AddWorkdaysAndSetDefaults extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        $typeBridge = new BridgeContentType();

        $weekdays = [
            'Monday',
            'Tuesday',
            'Wednesday',
            'Thursday',
            'Friday',
            'Saturday',
            'Sunday'
        ];

        $default = [];

        foreach ($weekdays as $day) {
            $uuid = $bridge->contentInsert('weekdays', [
                'title' => $day,
                'type' => 'node',
                'bundle' => 'weekdays'
            ]);
            $weekday = Weekdays::find($uuid);
            if ($weekday && !in_array($weekday->title, ["Saturday", "Sunday"])) {
                $default[] = ['target_uuid' => $weekday->uuid_host];
            }
        };

        $typeBridge->contentTypeUpdateField('dishes', 'weekdays', [
            'name' => 'weekdays',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'default' => $default,
            'required' => true,
            'weight' => 3,
            'title' => [
                'en' => 'Weekdays',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::OPTIONS_BUTTONS_WIDGET,
                'settings' => [],
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['weekdays'],
                'cardinality' => -1,
            ],
            ]);
    }

    public function down(): void
    {
    }
}
