<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Groups;
use Inside\Permission\Models\Role;

class FixMissingGroupRoles extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $groups = Groups::all();

        foreach ($groups as $group) {
            $roleMember = Role::where(
                [
                    'name' => 'group-' . $group->uuid . '-member',
                    'type' => 'group',
                ]
            )->first();
            if (!$roleMember) {
                Role::create(
                    [
                        'name' => 'group-' . $group->uuid . '-member',
                        'type' => 'group',
                    ]
                );
            }

            $roleAdmin = Role::where(
                [
                    'name' => 'group-' . $group->uuid . '-admin',
                    'type' => 'group',
                ]
            )->first();
            if (!$roleAdmin) {
                Role::create(
                    [
                        'name' => 'group-' . $group->uuid . '-admin',
                        'type' => 'group',
                    ]
                );
            }
        }
    }
}
