<?php

use Inside\Groups\Facades\GroupsHelper;
use Inside\LIED\Facades\GroupsEvents;

return [
    'hidden_types'       => [
        'groups_events',
    ],
    'non_implicit_permission_to_author_content_types' => [
        'groups_events',
    ],
    'global_scope'       => [
        function ($builder, $user, $model) {
            if (in_array($model->content_type, ['groups_events'])) {
                GroupsHelper::groupsTypesVisibilityScope($builder);
            }
        },
    ],
    'locked' => ['information_technologies_team', 'catering_services_team', 'reception_team', 'facilities_team'],
    'custom_permissions' => [
        /**
         * This is a custom callback when permission fails, we grant the possibility
         * to allow something
         */
        function (string $action, string $type, ?string $uuid): bool {
            return GroupsEvents::showGroupEventForm($action, $type, $uuid);
        },
    ],
];
