<?php

namespace Inside\LIED\Services;

use Illuminate\Support\Facades\Auth;
use Inside\Content\Models\Contents\Groups;
use Inside\Content\Models\Contents\Users;
use Inside\Groups\Facades\GroupsHelper;
use Inside\Permission\Models\User;
use Inside\Authentication\Models\User as AuthUser;

class GroupsEventsService
{
    /**
     * Show references too because regular users don't have the right to see them
     *
     * @param string $action
     * @param string $type
     * @param string|null $uuid
     * @return bool
     */
    public function showGroupEventForm(string $action, string $type, ?string $uuid): bool
    {
        $me = Auth::user();
        if (!$me instanceof AuthUser || !$uuid) {
            return false;
        }

        if (!in_array($action, ["create", "update"]) ||
            $type !== "groups_events") {
            return false;
        }
        $user = Users::find($me->uuid);
        $group = Groups::find($uuid);
        if (!$user || !$group) {
            return false;
        }
        $admin = GroupsHelper::isGroupAdmin($group, $user);

        /** @var User $permUser */
        $permUser = User::find($me->uuid);
        // should not happen
        if (!$admin && !$permUser->hasRole('super_administrator')) {
            return false;
        }
        return true;
    }
}
