<?php

namespace Inside\LIED\Providers;

use Inside\Application;
use Inside\Content\Contracts\Transformer;
use Inside\Content\Events\ContentCreatedEvent;
use Inside\Content\Events\ContentFullyInsertedEvent;
use Inside\Content\Events\ContentFullyUpdatedEvent;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\Content\Events\ContentSynchedEvent;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Content\Transformers\ContentTransformer;
use Inside\Events\InsideBooted;
use Inside\LIED\Events\EventFinishedEvent;
use Inside\LIED\Events\EventStartingEvent;
use Inside\LIED\Http\Middleware\AddReadinessStatusAndInternalContentOnReservationEditForm;
use Inside\LIED\Http\Middleware\FixGroupInProfil;
use Inside\LIED\Http\Middleware\PreventDuplicationInAssistants;
use Inside\LIED\Http\Middleware\RemoveNonAvailableServicesOnReservation;
use Inside\LIED\Http\Middleware\SaveCreditsOnFoodOrder;
use Inside\LIED\Http\Middleware\SaveReadinessStatusAndInternalContentOnReservationEditForm;
use Inside\LIED\Listeners\AddGroupsEvents;
use Inside\LIED\Listeners\ChangeWarnBeforeEvent;
use Inside\LIED\Listeners\ContentFullyUpdatedListener;
use Inside\LIED\Listeners\ContentInsertedListener;
use Inside\LIED\Listeners\DishesOrdersStatusEditedListener;
use Inside\LIED\Listeners\EventFinishedListener;
use Inside\LIED\Listeners\EventStartingListener;
use Inside\LIED\Listeners\GroupsEventsListener;
use Inside\LIED\Listeners\PrepareWarnBeforeEvent;
use Inside\LIED\Listeners\SetEventNotifications;
use Inside\LIED\Listeners\WarnTeamsOnReservationCreation;
use Inside\LIED\Listeners\WarnTeamsOnReservationModification;
use Inside\LIED\Repositories\ReservationsRepository;
use Inside\LIED\Services\ReservationsService;
use Inside\Reservation\Events\ParticipantsOnBookingCreationWarned;
use Inside\Reservation\Events\ParticipantsOnBookingModificationWarned;
use Inside\LIED\Listeners\SendOrdersMailListener;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentInsertedEvent::class => [
            ContentInsertedListener::class,
            GroupsEventsListener::class,
        ],
        ContentUpdatedEvent::class => [
            ChangeWarnBeforeEvent::class,
            SetEventNotifications::class,
        ],
        EventStartingEvent::class => [
            EventStartingListener::class,
        ],
        EventFinishedEvent::class => [
            EventFinishedListener::class,
        ],
        ContentSynchedEvent::class => [
            DishesOrdersStatusEditedListener::class,
        ],
        ContentCreatedEvent::class => [
            SendOrdersMailListener::class,
        ],
        ContentFullyInsertedEvent::class => [
            PrepareWarnBeforeEvent::class,
        ],
        ContentFullyUpdatedEvent::class => [
            ContentFullyUpdatedListener::class,
        ],
        ParticipantsOnBookingCreationWarned::class => [
            WarnTeamsOnReservationCreation::class,
        ],
        ParticipantsOnBookingModificationWarned::class => [
            WarnTeamsOnReservationModification::class,
        ],
        InsideBooted::class => [
            AddGroupsEvents::class,
        ],
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/imports.php', 'imports');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/permission.php', 'permission');
            $this->mergeConfigTo(__DIR__.'/../../config/reservation.php', 'reservation');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__ . '/../../config/ldap_auth.php', 'ldap_auth');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }

        $this->app->middleware(
            [
                RemoveNonAvailableServicesOnReservation::class,
                AddReadinessStatusAndInternalContentOnReservationEditForm::class,
                SaveReadinessStatusAndInternalContentOnReservationEditForm::class,
                SaveCreditsOnFoodOrder::class,
                FixGroupInProfil::class,
                PreventDuplicationInAssistants::class,
            ]
        );

        $this->app->singleton(
            ReservationsService::class,
            function ($app) {
                $transformer = $app->make(Transformer::class);
                return new ReservationsService($transformer, new ReservationsRepository());
            }
        );
    }
}
