<?php

namespace Inside\LIED\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Inside\Content\Models\Contents\RoomsReservations;
use Inside\Database\Eloquent\WithEnhancedBuilder;

class ReservationStatus extends Model
{
    use WithEnhancedBuilder;

    protected $table = 'inside_room_reservation_status';

    protected $casts = [
        'ready' => 'boolean',
    ];

    protected $fillable = [
        'room_reservation_id',
        'ready',
        'date',
        'comment',
    ];

    public function reservation(): BelongsTo
    {
        return $this->belongsTo(RoomsReservations::class, 'room_reservation_id', 'uuid');
    }
}
