<?php

namespace Inside\LIED\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Lang;

class NewOrder extends Mailable
{
    use Queueable;
    use SerializesModels;

    protected array $order;

    protected string $username;

    protected string $office;

    public function __construct(array $order, string $username, string $office)
    {
        $this->order = $order;
        $this->username = $username;
        $this->office = $office;
    }

    public function build(): NewOrder
    {
        $data = collect($this->order)->chunk(2)->transform(fn ($pair) => $pair->join(' : '))->implode("\n");

        $content = Lang::get('orders.mail.content', ['data' => $data, 'username' => $this->username, 'office' => $this->office]);

        return $this->markdown('notifications::email')
            ->subject(Lang::get("orders.mail.subject"))
            ->with([
                'level' => 'info',
                'introLines' => explode("\n", $content),
                'outroLines' => [],
                'actionText' => Lang::get('orders.mail.button'),
                'actionUrl' => url('/supplies-order/orders-listing'),
                'displayableActionUrl' => url('/supplies-order/orders-listing'),
            ]);
    }
}
