<?php

namespace Inside\LIED\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Carbon;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Content\Models\Contents\Events;
use Inside\LIED\Jobs\WarnUserThatEventBegins;
use Inside\LIED\Jobs\WarnUserToGiveFeedback;
use Inside\Notify\Listeners\BaseNotificationListener;

class SetEventNotifications extends BaseNotificationListener implements ShouldQueue
{
    public function handle(ContentUpdatedEvent $event): void
    {
        $model = $event->model;

        if (get_class($model) === Events::class) {
            $endDate   = get_date($model->end_date);
            $date = get_date($model->date);
            if (! $endDate || ! $date) {
                throw new \Exception('There is a problem with the given end date and date !');
            }

            if (config('queue.connections.lts', false)) {
                WarnUserThatEventBegins::dispatch($model)->delay($date->subMinutes(15))->onConnection(
                    'lts'
                );
                WarnUserToGiveFeedback::dispatch($model)->delay($endDate->addHour())->onConnection(
                    'lts'
                );
            }
        }
    }
}
