<?php

namespace Inside\LIED\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Mail;
use Inside\Content\Events\ContentCreatedEvent;
use Inside\Content\Models\Contents\Orders;
use Illuminate\Support\Facades\Log;
use Inside\Content\Models\Contents\Users;
use Inside\LIED\Mail\NewOrder;
use Inside\Permission\Models\Role;

class SendOrdersMailListener implements ShouldQueue
{
    public function handle(ContentCreatedEvent $event): void
    {
        $model = $event->model;

        if (get_class($model) !== Orders::class) {
            return;
        }
        $orders = [];
        foreach (json_decode($model->quantity) as $quantity) {
            if ($quantity->quantity === 0) {
                continue;
            }
            $orders[] = $quantity->title;
            $orders[] = $quantity->quantity;
        }
        $user = Users::findOrFail($model->author);
        $username = $user->firstname . ' ' . $user->lastname;
        $office = $user->office ?? 'Unknown';
        /** @var Role $role */
        $role = Role::where('name', 'facilities_team')->firstOrFail();
        Log::info((string) json_encode($role->users));
        foreach ($role->users as $user) {
            Mail::to($user->email)->send(new NewOrder($orders, $username, $office));
        }
    }
}
