<?php

namespace Inside\LIED\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Collection;
use Inside\Authentication\Models\User;
use Inside\Content\Events\ContentInsertedEvent;
use Inside\Content\Models\Contents\GroupsEvents;
use Inside\Groups\Facades\GroupsHelper;
use Inside\LIED\Events\GroupsEventsCreatedEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class GroupsEventsListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(ContentInsertedEvent $event): void
    {
        if (isset($event->model->content_type) && $event->model->content_type === "groups_events") {
            if (!isset($event->model->groups, $event->model->author)) {
                return;
            }
            $groups = $event->model->groups;
            /** @var Collection<NotificationType> $types */
            $types = NotificationType::where('model', GroupsEvents::class)->where('type', 'group')->where(
                'action',
                'custom'
            )->where(
                'event',
                GroupsEventsCreatedEvent::class
            )->get();

            $members     = GroupsHelper::getGroupMembers($groups->first(), $event->model->author);
            $subscribers = User::whereIn('uuid', $members->pluck('uuid'))->get();

            foreach ($types as $type) {
                $this->when = $this->getInterval($type, $event->model);
                foreach ($subscribers as $subscriber) {
                    $this->route = $subscriber;

                    if ($event->model->author == $subscriber->uuid) {
                        continue; // Don't notify the author !
                    }

                    if (!$this->checkUniqueness(
                        $type,
                        $event->model,
                        $subscriber
                    )
                    ) {
                        continue;
                    }

                    $this->notify($type, $subscriber, $event->model, ['from' => $event->model->author, 'url' => $groups->first()->slug[0]]);
                }
            }
        }
    }
}
