<?php

namespace Inside\LIED\Listeners;

use Carbon\Carbon;
use Illuminate\Support\Collection;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\Events;
use Inside\LIED\Events\EventStartingEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class EventStartingListener extends BaseNotificationListener
{
    public function handle(EventStartingEvent $event): void
    {
        $event = Events::find($event->event->uuid);
        /** @var Collection<NotificationType> $types */
        $types = NotificationType::where('event', 'Inside\Notify\Events\CustomNotificationEvent')
            ->where('model', 'Inside\Content\Models\Contents\Events')
            ->where('action', 'start')
            ->where('type', 'system')->get();

        foreach ($types as $type) {
            $event->reverseEventsSubscriptions->each(
                function ($subscription) use ($type, $event) {
                    /** @var User $subscriber */
                    $subscriber = User::find($subscription->author);
                    $this->route = $subscriber;
                    $this->notify($type, $subscriber, $event, ['url' => $event->slug[0], 'startingDate' => get_date($event->date)?->format("d/m/Y H:i")]);
                }
            );
        }
    }
}
