<?php

namespace Inside\LIED\Listeners;

use Illuminate\Support\Collection;
use Inside\Content\Events\ContentSynchedEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;
use Inside\Authentication\Models\User;

class DishesOrdersStatusEditedListener extends BaseNotificationListener
{
    public function handle(ContentSynchedEvent $event): void
    {
        $model = $event->model;
        $dirty = $event->dirty;
        if (get_class($model) === "Inside\Content\Models\Contents\DishesOrders") {
            $new_status = $dirty->first();

            if ($new_status->title === "Available") {
                /** @var Collection<NotificationType> $types */
                $types = NotificationType::where('model', get_class($model))->where(
                    function ($query) {
                        $query->where('action', 'isAvailable');
                    }
                )->get();

                /** @var User $subscriber */
                $subscriber = User::find($model->author);
                $author = $new_status->author;
                $url = 'my-orders/#&modal/' . class_to_type(get_class($model)) . '/' . $model->uuid;

                foreach ($types as $type) {
                    $this->when = $this->getInterval($type, $model);
                    $this->route = $subscriber;
                    $this->notify(
                        $type,
                        $subscriber,
                        $model,
                        [
                            'from' => $author,
                            'url' => $url
                        ]
                    );
                }
            }
        }
    }
}
