<?php

namespace Inside\LIED\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Notification;
use Inside\Content\Models\Contents\RoomsReservations;
use Inside\Jobs\Bus\Dispatchable;
use Inside\LIED\Notifications\ReservationEventIsAboutToStartNotification;
use Inside\Permission\Models\Role;

class WarnUsersBeforeEvent implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;

    /**
     * @var RoomsReservations
     */
    public $reservation;

    public function __construct(RoomsReservations $reservation)
    {
        $this->reservation = $reservation;
    }

    public function handle(): void
    {
        /** @var ?Role $cateringServiceTeam */
        $cateringServiceTeam = Role::where('name', 'catering_services_team')->first();

        if (! $cateringServiceTeam) {
            return;
        }

        $cateringServiceTeam->users->each(
            function ($user) {
                Notification::route('mail', $user->email)->notify(
                    (new ReservationEventIsAboutToStartNotification(
                        $this->reservation,
                        $this->reservation->creator,
                        'all-reservations'
                    ))->withIcs()
                );
            }
        );
    }
}
