<?php

namespace Inside\LIED\Http\Middleware;

use Illuminate\Http\Request;
use Inside\Host\Bridge\BridgeContent;
use Inside\Http\Middleware\TransformResponseAndRequest;

class SaveCreditsOnFoodOrder extends TransformResponseAndRequest
{
    protected array $paths = [
        'PUT' => [
            '#api/v1/content/users/([\da-f]{8}-[\da-f]{4}-[\da-f]{4}-[\da-f]{4}-[\da-f]{12})#iD',
        ],
    ];

    protected function patch(Request $request, mixed $response, array $data = []): mixed
    {
        // Update credits
        $credits = $request->input('credits');
        if ($credits !== null) {
            $bridge = new BridgeContent();
            $bridge->contentUpdate(
                'users',
                [
                    'uuid'    => $data[1],
                    'credits' => $credits,
                ]
            );
        }

        return $response;
    }
}
