<?php

namespace Inside\LIED\Http\Middleware;

use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use Inside\Content\Models\Contents\Users;
use Inside\Http\Middleware\TransformResponseAndRequest;
use Illuminate\Support\Facades\Validator;

class PreventDuplicationInAssistants extends TransformResponseAndRequest
{
    protected array $paths = [
        'PUT' => [
            '#api/v1/content/users/([\da-f]{8}-[\da-f]{4}-[\da-f]{4}-[\da-f]{4}-[\da-f]{12})#iD',
        ],
        'POST' => [
            '#api/v1/content/users/([\da-f]{8}-[\da-f]{4}-[\da-f]{4}-[\da-f]{4}-[\da-f]{12})#iD',
        ],
    ];

    protected function patch(Request $request, mixed $response, array $data = []): mixed
    {
        return $response;
    }

    protected function patchRequest(Request $request): Request
    {
        /** @var array $mainAssistant */
        $mainAssistant = $request->input('main_assistant_to');

        /** @var array $personnalAssistant */
        $personnalAssistant = $request->input('personnal_assistant_to');

        $validator = Validator::make($request->all(), [
            'main_assistant_to' => [
                function ($attribute, $value, $fail) use ($personnalAssistant) {
                    if (!empty($value) && !empty(array_intersect($value, $personnalAssistant))) {
                        $fail('You cannot be assistant and main assistant of the same user');
                    }
                }
            ],
            'personnal_assistant_to' => [
                function ($attribute, $value, $fail) use ($mainAssistant) {
                    if (!empty($value) && !empty($mainAssistant) && !empty(array_intersect($value, $mainAssistant))) {
                        $fail('You cannot be assistant and main assistant of the same user');
                    }
                }
            ]
        ]);

        if ($validator->fails()) {
            throw new ValidationException($validator);
        }

        return $request;
    }
}
