<?php

namespace Inside\LIED\Http\Middleware;

use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Carbon\Carbon as BaseCarbon;
use Inside\Content\Facades\ContentHelper;
use Inside\Http\Middleware\TransformResponseAndRequest;
use Inside\LIED\Models\ReservationStatus;

class AddReadinessStatusAndInternalContentOnReservationEditForm extends TransformResponseAndRequest
{
    protected array $paths = [
        'GET' => [
            'api/v1/content/rooms_reservations',
        ],
    ];

    protected ?BaseCarbon $date = null;

    protected ?array $fields = null;

    protected ?array $filters = null;

    protected function getFilters(Request $request): array
    {
        if ($this->filters === null) {
            $this->filters = ContentHelper::extractFiltersInputFromRequest($request);
        }

        return $this->filters;
    }

    protected function getFilter(Request $request, string $key): mixed
    {
        $filters = $this->getFilters($request);

        return $filters[$key] ?? null;
    }

    protected function getFields(Request $request): array
    {
        if ($this->fields === null) {
            $this->fields = ContentHelper::extractFieldsInputFromRequest($request);
        }

        return $this->fields;
    }

    protected function patchRequest(Request $request): Request
    {
        $request = ContentHelper::removeInputFromRequest($request, 'fields', 'readiness_status');
        $request = ContentHelper::removeInputFromRequest($request, 'fields', 'internal_comment');

        $dateFilter = $this->getFilter($request, 'date');

        if ($dateFilter === null) {
            return $request;
        }

        $formattedDate = get_date($dateFilter, 'Y-m-d');

        if (!$formattedDate) {
            return $request;
        }

        $this->date = $formattedDate->setTime(12, 0);

        return ContentHelper::removeInputFromRequest($request, 'filters', 'date');
    }

    protected function patch(Request $request, mixed $response, array $data = []): mixed
    {
        if (($uuid = $this->getFilter($request, 'uuid')) === null || $this->date === null) {
            return $response;
        }

        $reservationStatus = ReservationStatus::where('room_reservation_id', $uuid)->where(
            function ($query) {
                $query->where(
                    function ($query) {
                        $query->whereHas(
                            'reservation',
                            function ($query) {
                                $query->whereNotNull('frequency');
                            }
                        )->when(
                            $this->date !== null,
                            function ($query) {
                                $query->whereDate('date', '=', $this->date ? $this->date->format('Y-m-d') : null);
                            }
                        );
                    }
                )->orWhere(
                    function ($query) {
                        $query->whereHas(
                            'reservation',
                            function ($query) {
                                $query->whereNull('frequency');
                            }
                        )->whereNull('date');
                    }
                );
            }
        )->first();
        /** @var array $data */
        $data = json_decode_response($response);
        if (isset($data['data']) && !empty($data['data'])) {
            $reservation = array_first($data['data']);
            $reservation['readiness_status'] =
                ($reservationStatus === null || !$reservationStatus->ready) ? 'todo' : 'ready';
            $reservation['internal_comment'] = ($reservationStatus !== null) ? $reservationStatus->comment : null;
            $data['data'] = [$reservation];
            set_response($response, $data);
        }

        return $response;
    }
}
