<?php

namespace Inside\LIED\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Inside\Events\Dispatchable;
use Inside\Content\Models\Content;
use Inside\Authentication\Models\User;

class GroupsEventsCreatedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    public function __construct(
        public Content $model,
        public ?User $user
    ) {
    }

    public function broadcastOn(): Channel
    {
        return new Channel('inside_groups_events');
    }
}
