<?php

namespace Inside\LIED\Events;

use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Queue\SerializesModels;
use Inside\Content\Models\Contents\Events;
use Inside\Events\Dispatchable;

class EventFinishedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use SerializesModels;
    use Dispatchable;

    public function __construct(
        public Events $event
    ) {
    }

    public function broadcastOn(): Channel
    {
        return new Channel('lied_inside_event_finished');
    }
}
