<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class FixGroupsVisibility extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'groups',
            'visibility',
            [
                'type'                => BridgeContentType::LIST_STRING_FIELD,
                'name'                => 'visibility',
                'searchable'          => false,
                'translatable'        => true,
                'search_result_field' => true,
                'required'            => true,
                'weight'              => 2,
                'title'               => [
                    'en' => 'Visibility',
                ],
                'description' => [
                    'en' => 'Set group visibility',
                ],
                'settings' => [
                    'allowed_values' => [
                        'public'     => [
                            'en' => 'Public',
                        ],
                        'private'    => [
                            'en' => 'Private',
                        ],
                        'restricted' => [
                            'en' => 'Limited',
                        ],
                    ],
                ],
                'widget' => [
                    'type'     => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                ],
            ],
        );
    }
}
