<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddIntroAndBannerFieldsToCustomPage extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'custom',
            'introduction',
            [
                'name' => 'introduction',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => true,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'en' => 'Introduction',
                ],
                'description' => [
                    'en' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );
        $bridge->contentTypeCreateOrUpdateField(
            'custom',
            'banner',
            [
                'name' => 'banner',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => -4,
                'title' => [
                    'en' => 'Banner',
                ],
                'description' => [
                    'en' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::IMAGE_WIDGET,
                    'settings' => [
                        'progress_indicator' => 'throbber',
                        'preview_image_style' => 'thumbnail',
                    ],
                    'weight' => -4,
                ],
                'type' => BridgeContentType::IMAGE_FIELD,
                'settings' => [
                    'default_image' => [
                        'uuid' => '',
                        'alt' => '',
                        'title' => '',
                        'width' => '',
                        'height' => '',
                    ],
                    'target_type' => 'file',
                    'display_field' => false,
                    'display_default' => false,
                    'uri_scheme' => 'public',
                    'cardinality' => 1,
                ],
            ]
        );
    }
}
