<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ChangeCommentsLabel extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $types = ['events_feedbacks', 'events_subscriptions'];

        foreach ($types as $type) {
            $bridge->contentTypeUpdateField($type, 'message', [
                "title" => [
                    "en" => "Comment"
                ]
            ]);
        }
    }

    public function down(): void
    {
    }
}
