<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class ReworkAssistants extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('user', 'user', 'main_assistant');
        $bridge->contentTypeDeleteField('user', 'user', 'assistants');

        $bridge->contentTypeCreateOrUpdateField(
            'users',
            'main_assistant_to',
            [
                'name' => 'main_assistant_to',
                'type' => BridgeContentType::REFERENCE_FIELD,
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 12,
                'title' => [
                    'en' => 'Main assistant to',
                ],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'group' => 'group_contact'
                ],
                'settings' => [
                    'cardinality' => 1,
                    'target_type' => 'users',
                ],
            ],
            12
        );
    }

    public function down(): void
    {
    }
}
