<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class FixUsers extends Migration
{
    public function up(): void
    {
        $users = Users::all();
        $bridge = new BridgeContent();

        foreach ($users as $user) {
            $bridge->contentUpdate('users', [
                'uuid' => $user->uuid,
                'name' => $user->email,
                'job_title' => '',
            ]);
        }
    }

    public function down(): void
    {
    }
}
