<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Users;
use Inside\Notify\Models\NotificationSubscriber;
use Inside\Notify\Models\NotificationType;

class FixFeaturedDoubleNotifications extends Migration
{
    public function up(): void
    {
        $mailNotification = NotificationType::query()
            ->where('action', 'createOrUpdate')
            ->where('via', 'email')->first();
        if ($mailNotification instanceof NotificationType) {
            Users::all()->each(function ($user) use ($mailNotification) {
                NotificationSubscriber::firstOrCreate(
                    [
                       'user_uuid' => $user->uuid,
                       'notification_type_id' => $mailNotification->id
                   ]
                );
            });
        }
        NotificationType::query()
            ->where('action', 'createOrUpdate')
            ->each(function ($notificationType) {
                $notificationType->action = "create";
                $notificationType->default = true;
                $notificationType->save();
            });
    }

    public function down(): void
    {
    }
}
