<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class ChangeEventRegisterNotifToSystem extends Migration
{
    public function up(): void
    {
        NotificationType::query()->where('via', 'email')
            ->where('model', 'Inside\Content\Models\Contents\Events')
            ->where('event', 'Inside\Notify\Events\CustomNotificationEvent')
            ->where('action', 'custom')->each(function ($type) {
                $type->action = "system";
                $type->data = [
                   'title' => "notifications.events.register.title",
                   'description' => "notifications.events.register.title",
                   'mail' => [
                       'subject' => 'notifications.events.register.subject',
                       'text' => 'notifications.events.register.text',
                       'buttonText' => 'notifications.events.register.buttonText'
                   ],
                   'fields' => [
                       ['author' => ['firstname', 'lastname']],
                       'title'
                   ]
               ];
                $type->save();
            });
    }

    public function down(): void
    {
    }
}
