<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateCtaParagraph extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'call_to_action',
            'link_title',
            [
                'name'        => 'link_title',
                'default'     => null,
                'required'    => true,
                'weight'      => 6,
                'title'       => [
                    'fr' => 'Titre du lien',
                    'en' => 'Titre du lien',
                ],
                'description' => [
                    'fr' => '',
                    'en' => '',
                ],
                'widget'      => [
                    'type'     => BridgeContentType::TEXT_WIDGET,
                    'settings' => [],
                ],
                'type'        => BridgeContentType::TEXT_FIELD,
                'settings'    => [
                    'max_length'     => 255,
                    'is_ascii'       => false,
                    'case_sensitive' => false,
                    'cardinality'    => 1,
                ],
            ],
            6,
            'paragraph'
        );
    }

    public function down(): void
    {
    }
}
