<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class ManageGroupsFields extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $bridge = new BridgeContent();
        $groups = [];

        \Inside\Content\Models\Contents\GroupsDocuments::each(
            function ($document) use (&$groups) {
                $groups[] = [
                    'uuid' => $document->uuid,
                    'group' => $document->groups()->first()->uuid
                ];
            }
        );

        $bridgeContentType->contentTypeDeleteField('node', 'groups_documents', 'groups');

        $this->bootUp(__FILE__);
        $this->migrateContent('groups_documents', false);
        $this->finishUp();

        foreach ($groups as $group) {
            $bridge->contentUpdate(
                'groups_documents',
                [
                    'type' => 'node',
                    'bundle' => 'groups_documents',
                    'uuid' => $group['uuid'],
                    'groups' => $group['group']
                ]
            );
        }
    }

    public function down(): void
    {
    }
}
