<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class ManageEventsCategoriesFields extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContent();
        $bridgeContentType = new BridgeContentType();

        $types = ['events', 'groups_events'];

        foreach ($types as $type) {
            $model = 'Inside\Content\Models\Contents\\'.studly_case($type);
            $content = call_user_func($model.'::all');
            $categories = [];

            foreach ($content as $event) {
                $categories[] = [
                    'uuid' => $event->uuid,
                    'category' => $event->eventsCategories()->first()->uuid
                ];
            }

            $bridgeContentType->contentTypeDeleteField('node', $type, 'events_categories');
            $bridgeContentType->contentTypeCreateOrUpdateField($type, 'events_categories', [
                'name' => 'events_categories',
                'searchable' => true,
                'translatable' => false,
                'default' => false,
                'search_result_field' => true,
                'required' => false,
                'weight' => 13,
                'title' => [
                    'en' => 'Event Categories',
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 13,
                    'group' => 'group_options',
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['events_categories'],
                    'cardinality' => 1,
                ],
            ]);

            foreach ($categories as $category) {
                $bridge->contentUpdate(
                    $type,
                    [
                        'type' => 'node',
                        'bundle' => $type,
                        'uuid' => $category["uuid"],
                        'events_categories' => $category["category"]
                    ]
                );
            }
        }
    }

    public function down(): void
    {
    }
}
