<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\DishesOrdersStatus;
use Inside\Notify\Events\CustomNotificationEvent;
use Inside\Notify\Models\NotificationType;

class CreateOrderNotifications extends Migration
{
    public function up(): void
    {
        $orderStatus = DishesOrdersStatus::where('title', 'Waiting')->first();

        NotificationType::firstOrCreate(
            [
                'via' => 'web',
                'default' => false,
                'event' => CustomNotificationEvent::class,
                'model' => 'Inside\Content\Models\Contents\DishesOrders',
                'action' => 'dishes',
                'type' => 'system',
                'condition' => 'dishes_orders_status:' . $orderStatus->uuid,
                'multiple' => true,
                'language' => false,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => 'notifications.dishes.order.title',
                    'text' => 'notifications.dishes.order.text',
                    'fields' => [
                        'title',
                    ],
                    'url' => 'restaurants-admin'
                ]
            ]
        );
        NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'event' => CustomNotificationEvent::class,
                'model' => 'Inside\Content\Models\Contents\DishesOrders',
                'action' => 'dishes',
                'type' => 'system',
                'condition' => 'dishes_orders_status:' . $orderStatus->uuid,
                'multiple' => true,
                'language' => false,
                'profile' => false,
            ],
            [
                'data' => [
                    'title' => "notifications.dishes.order.title",
                    'description' => 'notifications.dishes.order.description',
                    'mail' => [
                        'subject' => 'notifications.dishes.order.subject',
                        'text' => 'notifications.dishes.order.content',
                        'buttonText' => 'notifications.dishes.order.buttonText'
                    ],
                    'fields' => [
                        'title'
                    ],
                    'url' => 'restaurants-admin'
                ]
            ]
        );
    }

    public function down(): void
    {
    }
}
