<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AddEventsNotifications extends Migration
{
    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via' => 'email',
                'default' => false,
                'event' => 'Inside\Notify\Events\CustomNotificationEvent',
                'model' => 'Inside\Content\Models\Contents\Events',
                'action' => 'feedback',
                'type' => 'system',
                'condition' => '',
                'multiple' => true,
                'language' => false,
                'profile' => false,
                'data' => [
                    'title' => "notifications.feedback.event.title",
                    'description' => 'notifications.feedback.event.description',
                    'mail' => [
                        'subject' => 'notifications.feedback.event.subject',
                        'text' => 'notifications.feedback.event.content',
                        'buttonText' => 'notifications.feedback.event.buttonText'
                    ],
                    'fields' => [
                        ['author' => ['firstname', 'lastname']],
                        'title'
                    ],
                ]
            ]
        );
    }

    public function down(): void
    {
    }
}
