<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditOfficeField extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('user', 'user', 'office');
        $bridge->contentTypeCreateField(
            'users',
            'office',
            [
                'name' => 'office',
                'type' => BridgeContentType::TEXT_FIELD,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'editable' => false,
                'required' => false,
                'weight' => 14,
                'title' => [
                    'en' => 'Office',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'weight' => 14,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            14
        );
    }

    public function down(): void
    {
    }
}
