<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class EditNewsCriticalityWidgetType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'news',
            'news_criticalities',
            [
               'name' => 'news_criticalities',
               'searchable' => true,
               'translatable' => false,
               'search_result_field' => false,
               'default' => null,
               'required' => false,
               'weight' => 2,
               'title' => [
                   'en' => 'News Criticality',
               ],
               'description' => [],
               'widget' => [
                   'type' => BridgeContentType::SELECT_WIDGET,
                   'settings' => [],
                   'group' => 'group_options',
               ],
               'type' => BridgeContentType::REFERENCE_FIELD,
               'settings' => [
                   'target_type' => ['news_criticalities'],
                   'cardinality' => -1,
               ],
           ],
            2
        );
    }

    public function down(): void
    {
    }
}
