<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;

class AddDefaultEventsContent extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        $component = ['one', 'two', 'three'];

        for ($idx = 1; $idx <= 3; $idx++) {
            $bridge->contentInsert('register_forms', [
                'title' => 'Register form ' . $idx,
                'component' => 'register-forms-' . $component[$idx - 1] . '-customs',
                'custom_form_type' => $idx,
                'type' => 'node',
                'bundle' => 'register_forms'
            ]);

            if ($idx !== 3) {
                $bridge->contentInsert('feedback_forms', [
                    'title' => 'Feedback form ' . $idx,
                    'component' => 'feedback-forms-' . $component[$idx - 1] . '-customs',
                    'custom_form_type' => $idx,
                    'type' => 'node',
                    'bundle' => 'feedback_forms'
                ]);
            }
        }
    }

    public function down(): void
    {
    }
}
