<?php

return [
    'email_following_users' => true,
    'build_url_callbacks' => [
        'external' => function ($model) {
            return env('APP_URL') . '/' . protected_file_url($model, 'file');
        }
    ],
    'manual_notifications' => [
        'enabled' => true,
        'enhanced_notifications' => true,
        'enhanced_notifications_types_and_fields' => [
            'news' => [
                'fields' => [
                    'image',
                    'chapo',
                ]
            ],
            'events' => [
                'fields' => [
                    'image',
                    'chapo',
                ]
            ],
            'external_notifications' => [
                'fields' => [
                    'image',
                ],
            ],
        ],
        'enabled_types' => [
            'news',
            'events',
            'documents'
        ],
    ],
];
