<?php

return [
    'reservations' => [
        'content_type'    => 'rooms_reservations',
        'format'          => [
            'driver'  => 'csv',
            'options' => [
                'delimiter' => ';',
                'enclosure' => '"',
                'escape'    => '\\',
                'offset'    => 0,
            ],
        ],
        'fields'          => [],
        'default_exports' => [
            [
                // Le nom de la réservation
                'title' => [
                    'order' => 0,
                ],
            ],
            [
                'rooms' => [
                    'fields' => [
                        [
                            // Le nom de la salle
                            'title' => [
                                'order' => 1,
                            ],
                        ],
                    ],
                ],
            ],
            [
                // Le nombre d'invité en interne
                'internal_users' => [
                    'count'  => [
                        'order' => 4,
                    ],
                    'fields' => [],
                ],
            ],
            [
                'external_users' => [
                    'fields' => [
                        [
                            // Le nombre d'invité en externe
                            'count' => [
                                'order'    => 5,
                                'callback' => function ($information) {
                                    $externalUsers = $information->external_users;
                                    if (is_string($externalUsers)  && !empty($externalUsers)) {
                                        $externalUsers = explode(',', $externalUsers);
                                        return count($externalUsers);
                                    }
                                    return 0;
                                },
                            ],
                        ],
                        [
                            // Les noms des invité en externe
                            'name' => [
                                'order'    => 6,
                                'callback' => function ($information) {
                                    $externalUsers = $information->external_users;
                                    if (is_string($externalUsers)  && !empty($externalUsers)) {
                                        $externalUsers = explode(',', $externalUsers);
                                        return implode(" - ", $externalUsers);
                                    }
                                    return '';
                                },
                            ],
                        ],
                    ],
                ],
            ],
            [
                'start_date' => [
                    'order' => 2,
                ],
            ],
            [
                'end_date' => [
                    'order' => 3,
                ],
            ],
        ],
        'preFlight'       => function ($console) {
        },
        'finishing'       => function ($record, \Inside\Host\Bridge\BridgeContent $bridge, $uuid, $console = null) {

        },
        'key'             => [
            // Keys
            'import' => 'ID',
            'inside' => 'uuid',
        ],
    ],
];
