<?php

declare(strict_types=1);

namespace Inside\LHG\Providers;

use Inside\Archive\Events\ContentArchivedEvent;
use Inside\Archive\Events\ContentRestoredEvent;
use Inside\LHG\Console\DeleteCorruptedUsers;
use Inside\LHG\Console\DuplicateMissingContent;
use Inside\LHG\Console\EqualizeContentWorkflow;
use Inside\LHG\Console\RetryFailedMysqlJobs;
use Inside\LHG\Http\Middlewares\TranslationMiddleware;
use Inside\LHG\Listeners\ContentArchivedListener;
use Inside\LHG\Listeners\ContentRestoredListener;
use Inside\LHG\Services\RightApiService;
use Inside\Permission\Services\PermissionService;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * LHG Service provider.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
final class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentRestoredEvent::class => [
            ContentRestoredListener::class,
        ],
        ContentArchivedEvent::class => [
            ContentArchivedListener::class,
        ],
    ];

    protected array $commands = [
        DeleteCorruptedUsers::class,
        DuplicateMissingContent::class,
        EqualizeContentWorkflow::class,
        RetryFailedMysqlJobs::class,
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/import.php', 'import');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/louvrehotels.php', 'louvrehotels');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/lhg_import.php', 'lhg_import');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigFrom(__DIR__.'/../../config/right.php', 'right');
            $this->mergeConfigTo(__DIR__.'/../../config/workflow.php', 'workflow');

            if (! PermissionService::isSystemV2Initialized()) {
                $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/permission.php', 'permission');
            }
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }

        $this->app->middleware([
            TranslationMiddleware::class,
        ]);

        $this->app->singleton(RightApiService::class, function () {
            return new RightApiService(config('right.endpoint'), config('right.api_key'));
        });
    }
}
