<?php

namespace Inside\LHG\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Inside\Archive\Events\ContentRestoredEvent;
use Inside\Archive\Services\ArchiveService;

/**
 * Content restored listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentRestoredListener implements ShouldQueue
{
    public function handle(ContentRestoredEvent $event): void
    {
        $model = $event->content;

        $langcode = $model->langcode === 'en' ? 'fr' : 'en';
        $translation = $model->getTranslationIfExists($langcode);

        if ($translation && $translation->langcode !== $model->langcode) {
            $archiveService = new ArchiveService();
            $archiveService->restoreContent((string) get_class($model), $translation->uuid, true, true);
        }
    }
}
