<?php

namespace Inside\LHG\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\DB;
use Inside\Archive\Events\ContentArchivedEvent;
use Inside\Archive\Models\Archive;
use Inside\Archive\Services\ArchiveService;

/**
 * Content archived listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ContentArchivedListener implements ShouldQueue
{
    public function handle(ContentArchivedEvent $event): void
    {
        $model = $event->content;

        $archive = Archive::where('type', get_class($model))->where('uuid', $model->uuid)->first();

        if ($archive instanceof Archive) {
            $langcode = $model->langcode === 'en' ? 'fr' : 'en';
            $translation = $model->getTranslationIfExists($langcode);
            if ($translation && $translation->langcode !== $model->langcode) {
                $archiveService = new ArchiveService();
                $archiveService->archiveContent((string) get_class($model), $translation->uuid, strtotime($archive->date) ?: null, true, true);
            }
        }
    }
}
