<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Database\Migrations\HasConsole;
use Inside\Host\Bridge\BridgeContentType;

class RemoveUpdatedByField extends Migration
{
    use HasConsole;

    public function up(): void
    {
        $models = Inside\Content\Facades\Schema::getModelsWithField('updated_by');
        $bridge = new BridgeContentType();

        foreach ($models as $model) {
            $entityType = $model !== 'users' ? 'node' : 'user';

            $bridge->contentTypeDeleteField($entityType, $model, 'updated_by');
        }
    }
}
