<?php

use Illuminate\Support\Facades\DB;

return [
    'locked' => [],
    'apply_permission_scope' => function ($user, $model) {
        $contentTypes = config('louvrehotels.rights.contentTypes', []);

        if (empty($contentTypes) || ! in_array($model->content_type, $contentTypes) || $model->content_type === 'p_and_p_regions') {
            return true;
        }

        return false;
    },
    'global_scope' => function ($builder, $user, $model) {
        $contentTypes = config('louvrehotels.rights.contentTypes', []);

        if (empty($contentTypes) || ! in_array($model->content_type, $contentTypes) || $model->content_type === 'p_and_p_regions') {
            return;
        }

        $references = ['brands', 'profiles', 'countries', 'management_modes'];

        $userReferences = [];

        foreach ($references as $reference) {
            if ($reference === 'brands' && request()->has('currentBrand')) {
                $brand = Inside\Content\Models\Contents\Brands::query()->find(request()->get('currentBrand'));
                $userReferences['brands'] = [$brand->uuid_host];
                continue;
            }

            $userReferences[$reference] = DB::table('inside_pivots')->where('parent_uuid', $user->uuid)->where('related_type', type_to_class($reference))->where('related_langcode', $user->langcode)->where('related_field', $reference)->pluck('related_uuid')->toArray();
            $userReferences[$reference] = DB::table(type_to_table($reference) ?? '')->whereIn('uuid', $userReferences[$reference])->pluck('uuid_host')->toArray();
        }

        $builder->where(function ($subquery) use ($model, $user, $userReferences) {
            /** @var string $class */
            $class = get_class($model);
            $table = class_to_table($class);
            $subquery->orWhereIn($table.'.uuid', function ($where) use ($user, $table) {
                $where->select('uuid')
                    ->from($table)
                    ->where('author', $user->uuid);
            })->orWhereIn($table.'.uuid', function ($where) use ($userReferences, $user, $table) {
                $where->select('uuid')
                    ->from($table);

                foreach ($userReferences as $field => $uuids) {
                    $alias = 'pivots'.studly_case($field);
                    $total = DB::table(type_to_table($field) ?? '')->where('langcode', $user->langcode)->count();

                    if (count($uuids) === $total) {
                        continue;
                    }

                    $uuids = DB::table(type_to_table($field) ?? '')->whereIn('uuid_host', $uuids)->pluck('uuid')->toArray();

                    $where->join('inside_pivots AS '.$alias, function ($join) use ($alias, $uuids, $table) {
                        $join->on($alias.'.parent_uuid', '=', $table.'.uuid')
                            ->where(function ($query) use ($alias, $uuids) {
                                $query->whereIn($alias.'.related_uuid', $uuids);
                            });
                    });
                }
            })->groupBy($table.'.uuid');
        });
    },
];
