<?php

namespace Inside\LHG\Services;

use Illuminate\Database\Eloquent\Collection;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Content;

class BusinessAccessLogicService
{
    private static function sharingAtLeastOneAttribute(User $user, Content $content, string $attribute): bool
    {
        /** @var Collection|null $contentAttribute */
        $contentAttribute = $content->{$attribute};

        /** @var Collection|null $contentAttribute */
        $userAttribute = $user->information->{$attribute};

        return $contentAttribute?->pluck('uuid')->intersect($userAttribute?->pluck('uuid'))->isNotEmpty() ?? false;
    }

    public static function hasNecessaryBrandAccess(User $user, Content $content): bool
    {
        return self::sharingAtLeastOneAttribute($user, $content, 'brands');
    }

    public static function hasNecessaryCountryAccess(User $user, Content $content): bool
    {
        return self::sharingAtLeastOneAttribute($user, $content, 'countries');
    }

    public static function hasNecessaryManagementModeAccess(User $user, Content $content): bool
    {
        return self::sharingAtLeastOneAttribute($user, $content, 'managementModes');
    }

    public static function hasNecessaryProfileAccess(User $user, Content $content): bool
    {
        return self::sharingAtLeastOneAttribute($user, $content, 'profiles');
    }

    public static function hasNecessaryAccess(User $user, Content $content): bool
    {
        return self::hasNecessaryBrandAccess($user, $content) &&
            self::hasNecessaryCountryAccess($user, $content) &&
            self::hasNecessaryManagementModeAccess($user, $content) &&
            self::hasNecessaryProfileAccess($user, $content);
    }
}
