<?php

declare(strict_types=1);

namespace Inside\LHG\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder as EloquentBuilder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Inside\Content\Models\Content;

/**
 * @property int $id
 * @property string $filename
 * @property string $new_filename
 * @property-read Content $source
 * @property-read Content|null $destination
 * @property-read Carbon $created_at
 * @property-read Carbon $updated_at
 *
 * @method static LhgWysiwygImage create(array $attributes = [])
 * @method static EloquentBuilder where($column, $operator = null, $value = null, $boolean = 'and')
 */
final class LhgWysiwygImage extends Model
{
    protected $guarded = [];

    public function source(): MorphTo
    {
        return $this->morphTo('contentable');
    }

    public function destination(): MorphTo
    {
        return $this->morphTo('destinable');
    }
}
