<?php

declare(strict_types=1);

namespace Inside\LHG\Jobs;

use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Log;
use Inside\Host\Bridge\BridgeContent;
use Inside\Jobs\Job;

final class UpdateContentThroughJob extends Job
{
    public function __construct(
        protected string $type,
        protected array $data,
    ) {
    }

    public function handle(): void
    {
        try {
            Log::info('[LHG Commons] UpdateContentThroughJob: Starting the update of content type '.$this->type.' named '.$this->data['title'].' in '.$this->data['langcode']);

            (new BridgeContent())->contentUpdate($this->type, $this->data);

            Log::info('[LHG Commons] UpdateContentThroughJob: Content updated');
        } catch (\Exception $e) {
            Log::error('[LHG Commons] UpdateContentThroughJob: Error during save. Dispatching job again, delayed for 2 minutes: '.$e->getMessage());

            Artisan::call('queue:restart');
            self::dispatch($this->type, $this->data)->onQueue(get_high_priority_queue_name())->delay(now()->addMinutes(2));
        }
    }
}
