<?php

declare(strict_types=1);

namespace Inside\LHG\Jobs;

use Illuminate\Support\Facades\Log;
use Inside\Jobs\Job;

final class TranslateArchiveJob extends Job
{
    public function __construct(
        protected string $type,
        protected mixed $source,
        protected string $langcode
    ) {
    }

    public function handle(): void
    {
        $translatedContent = type_to_class($this->type)::where([
            'uuid_host' => $this->source->uuid_host,
            'langcode' => $this->langcode,
        ])->first();

        if ($this->source->archive?->date) {
            $translatedContent->archive()->create([
                'date' => $this->source->archive->date,
            ]);
        } else {
            $translatedContent->archive()->delete();
        }
    }
}
