<?php

namespace Inside\LHG\Importers;

use Inside\Host\Bridge\BridgeContent;
use Inside\Import\Contracts\ImporterInterface;
use Inside\LHG\Facades\RightApi;
use Inside\LHG\Services\RightApiService;

class RightImporter implements ImporterInterface
{
    public function prepareImport(): bool
    {
        return true;
    }

    public function getSyncAttributes(mixed $user, array $entry, BridgeContent $bridge): array
    {
        $syncAttributes = $entry['sync_attributes'];

        $data = collect($syncAttributes)->map(function (mixed $attribute) use ($user) {
            if (! isset($attribute)) {
                return null;
            }

            return is_callable($attribute) ? $attribute($user) : data_get($user, $attribute);
        })->all();

        $postSync = config('right.post_sync');

        if (is_callable($postSync)) {
            $postSync($data);
        }

        return $data;
    }

    public function getUsers(array $entry, ?string $filter, ?string $test = null, int $limit = 0): array
    {
        $total = RightApi::getUsersCount();
        $page = ceil($total / 100);

        $users = collect();

        for ($i = 0; $i < $page; $i++) {
            $users = $users->merge(RightApi::getUsers(100, $i * 100));
        }

        $postFilter = $entry['postfilter'];

        if (is_callable($postFilter)) {
            $users = $postFilter($users);
        }

        return $users->all();
    }

    public function getEntries(): array
    {
        $default = config('right');

        $entries = $default['entries'] ?? [];

        if (empty($entries)) {
            return ['default' => $default];
        }

        return array_map(fn (array $entry) => array_merge($default, $entry), $entries);
    }

    public function getUserInformation(?string $username, array $entry): ?array
    {
        if (is_null($username)) {
            return null;
        }

        return RightApi::getUser($username);
    }

    public function getCleanData()
    {
        return config('right.cleandata');
    }

    public function getPreFlight()
    {
        return config('right.preflight');
    }

    public function getPostFlight()
    {
        return config('right.postflight');
    }

    public function getFilter(): ?string
    {
        return config('right.filter');
    }
}
