<?php

namespace Inside\LHG\Http\Middlewares;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use Inside\LHG\Actions\TranslateContent;
use Inside\LHG\Actions\TranslateRestoredContent;
use Symfony\Component\HttpFoundation\Response;

/**
 * Handle automatic translation
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class TranslationMiddleware
{
    public function handle(Request $request, Closure $next): mixed
    {
        return match (true) {
            preg_match('/api\/v1\/content\/\w+$/i', $request->path()) && $request->isMethod('POST') => (new TranslateContent($request, $next))->handle(),
            preg_match('/api\/v1\/content\/\w+\/(-?[0-9A-F]{4,12}){5}$/i', $request->path()) && $request->is('api/v1/content/*/*') && $request->isMethod('PUT') => (new TranslateContent($request, $next))->handle(),
            $request->is('api/v1/revision/*/*/*') && $request->isMethod('POST') => (new TranslateRestoredContent($request, $next))->handle(),
            default => $next($request),
        };
    }
}
